#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// voronoi experimentsMod01.fsh  by   skal 
//https://www.shadertoy.com/view/ftByDD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//
// Playing with Voronoi smooth distance
//
//  (basically redoing https://www.shadertoy.com/view/ldl3W8 on my own)
//
////////////////////////////////////////////////////////////////////////

#define ISO_PHASE 5.    // to animate the iso-lines
#define SMOOTH_MIN_PHASE 5.

// see https://www.shadertoy.com/view/4djSRW
vec2 hash2(vec2 p) {
  vec3 p3 = fract(vec3(p.xyx) * vec3(.1021, .1013, .0977));
  p3 += dot(p3, p3.yzx + 33.33);
  return fract((p3.xx + p3.yz) * p3.zy);
}

////////////////////////////////////////////////////////////////////////
// distance from origin to segment [p1, p2]
float SegmentDistance(vec2 p1, vec2 p2) {
  vec2 dir = p2 - p1;
  float norm = 1. / dot(dir, dir);
  float frac = clamp(norm * dot(dir, -p1), 0.0, 1.0);
  return length(p1 + frac * dir);
}

// distance from origin to (p1+p2)/2 along (p1->p2)
float CellDistance(vec2 p1, vec2 p2) {
  vec2 mid = 0.5 * (p1 + p2);
  vec2 dir = normalize(p2 - p1);
  return dot(mid, dir);
}

////////////////////////////////////////////////////////////////////////

vec2 GetCenter(vec2 id, float theta) {
  vec2 phi = 6.283185 * hash2(id) + theta;
  return 0.5 + 0.5 * sin(phi);
}

float VoronoiDistance(vec2 p, float t, int n, out vec2 p1) {
  vec2 cell = floor(p);
  vec2 sub_pos = fract(p);
  float d1 = 1.e6, d2 = 1.e7;
  vec2 p2;
  for (int j = -n; j <= n; ++j) {
    for (int i = -n; i <= n; ++i) {
      vec2 offset = vec2(float(i), float(j));
      vec2 center = offset + GetCenter(cell + offset, t) - sub_pos;
      float d = dot(center, center);
      if (d < d1) {
        d2 = d1;
        d1 = d;
        p2 = p1;
        p1 = center;
      } else if (d < d2) {
        d2 = d;
        p2 = center;
      }
    }
  }
  return SegmentDistance(p1, p2);
}

// polynomial smooth min
float smin(float a, float b, float k) {
  float h = max(k - abs(a - b), 0.0) / k;
  return min(a, b) - h * h * k * 0.25;
}

float VoronoiMin(vec2 p, float t, int n, vec2 p1, float k) {
  vec2 cell = floor(p);
  vec2 sub_pos = fract(p);
  float d_min = 1.e6;
  for (int j = -n; j <= n; ++j) {
    for (int i = -n; i <= n; ++i) {
      vec2 offset = vec2(float(i), float(j));
      vec2 p = offset + GetCenter(cell + offset, t) - sub_pos;
      if (dot(p - p1, p - p1) > 0.001) {  // not the immediate center?  
        d_min = smin(CellDistance(p1, p), d_min, k);
      }
    }
  }
  return d_min;
}

////////////////////////////////////////////////////////////////////////

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 uv = 6. * fragCoord / iResolution.y;
  float theta = iTime * 1.2;
  float blend =
      mix(0.01, 0.38, 0.5 + 0.5 * sin(SMOOTH_MIN_PHASE * theta));
  vec2 p1;
  float d12 = VoronoiDistance(uv, theta, 1, p1);
  float d = VoronoiMin(uv, theta, 2, p1, blend);

  vec3 col = vec3(0.);
  if (true) {  // draw a line p2 -> p1
    col = mix(vec3(0.2, 0.2, 0.7), col, smoothstep(0.00, 0.06, d12));
  }
  if (true) {  // draw iso-lines
    float iso_d = d * (0.5 + 0.5 * sin(60. * d + iTime * ISO_PHASE));
    float amp = 0.5 + 0.5 * sin(2. * theta * 0.5);
    col = mix(col, amp*vec3(0.76, 0.45, 0.96), smoothstep(0.0, 0.3, iso_d));
  }
  if (true) {  // draw cell borders
    col = mix(vec3(0.35, 0.65, 0.20), col, smoothstep(0.00, 0.02, d));
  }
  if (true) {  // draw centers
    float d = dot(p1, p1);
    col = mix(vec3(0.97, 0.8, 0.3), col, smoothstep(0.002, 0.005, d));
  }
  fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

